<?xml version="1.0" encoding="UTF-8"?>
<!-- El objetivo de este archivo SLD, es el de simbolizar la entidad urbanística correspondiente según lo indicado en la "Instrucción técnica de estandarización y normalización de instrumentos de planeamiento (ITU-PL1)". Antes de su uso deberá revisar las etiquetas que hacen referencia a los campos existentes en las tablas de datos, especialmente los destinados a simbolizar por categorías, los de elementos alfanuméricos y los de geometría. Su definición puede admitir variantes y ser mejorada. Si es el caso, por favor, comparta su conocimiento para que futuros usuarios puedan beneficiarse. Gracias. | Murcia, mayo de 2024 | SERVICIO DE URBANISMO | https://www.urbmurcia.es/web/urbmurcia/contacto | -->
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" version="1.0.0">
	<sld:NamedLayer>
		<sld:Name>17_valores_riesgos</sld:Name>
		<sld:UserStyle>
			<sld:Name>17_valores_riesgos</sld:Name>
			<sld:Title>Valores y riesgos</sld:Title>
			<sld:FeatureTypeStyle>
				<sld:Name>name</sld:Name>
				<sld:Rule>
					<sld:Name>riesgos</sld:Name>
					<sld:Title>Riesgos (vRN, vRI, vRX)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:Or>
							<ogc:Or>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>Código</ogc:PropertyName>
									<ogc:Literal>vRN</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>Código</ogc:PropertyName>
									<ogc:Literal>vRI</ogc:Literal>
								</ogc:PropertyIsEqualTo>
							</ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>Código</ogc:PropertyName>
								<ogc:Literal>vRX</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:Or>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Fill>
							<sld:GraphicFill>
								<sld:Graphic>
									<sld:ExternalGraphic>
										<sld:OnlineResource xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:href="file:riesgos.svg"/>
										<sld:Format>image/svg+xml</sld:Format>
									</sld:ExternalGraphic>
									<sld:Size>50.0</sld:Size>
								</sld:Graphic>
							</sld:GraphicFill>
						</sld:Fill>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#464664</sld:CssParameter>
							<sld:CssParameter name="stroke-width">2.0</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">3.0</sld:CssParameter>
						</sld:Stroke>
					</sld:PolygonSymbolizer>
					<sld:TextSymbolizer>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Sans</sld:CssParameter>
							<sld:CssParameter name="font-size">10</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#464664</sld:CssParameter>
						</sld:Fill>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>etiqueta</sld:Name>
					<sld:Title/>
					<sld:Abstract/>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Código</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">10</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#FF9600</sld:CssParameter>
						</sld:Fill>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>Valores naturales</sld:Name>
					<sld:Title>Valores naturales (vMB, vMP, vMT)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:Or>
							<ogc:Or>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>Código</ogc:PropertyName>
									<ogc:Literal>vMB</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>Código</ogc:PropertyName>
									<ogc:Literal>vMP</ogc:Literal>
								</ogc:PropertyIsEqualTo>
							</ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>Código</ogc:PropertyName>
								<ogc:Literal>vMT</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:Or>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#78A050</sld:CssParameter>
							<sld:CssParameter name="stroke-width">2.0</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">3.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>Valores culturales</sld:Name>
					<sld:Title>Valores culturales (vAQ, vCU, vPA)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:Or>
							<ogc:Or>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>Código</ogc:PropertyName>
									<ogc:Literal>vAQ</ogc:Literal>
								</ogc:PropertyIsEqualTo>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>Código</ogc:PropertyName>
									<ogc:Literal>vCU</ogc:Literal>
								</ogc:PropertyIsEqualTo>
							</ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>Código</ogc:PropertyName>
								<ogc:Literal>vPA</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:Or>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#78503C</sld:CssParameter>
							<sld:CssParameter name="stroke-width">2.0</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">3.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>Otros valores</sld:Name>
					<sld:Title>Otros valores (vCK, vAG, vAF, vAM, vSO, vXX)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:Or>
							<ogc:Or>
								<ogc:Or>
									<ogc:Or>
										<ogc:Or>
											<ogc:PropertyIsEqualTo>
												<ogc:PropertyName>Código</ogc:PropertyName>
												<ogc:Literal>vCK</ogc:Literal>
											</ogc:PropertyIsEqualTo>
											<ogc:PropertyIsEqualTo>
												<ogc:PropertyName>Código</ogc:PropertyName>
												<ogc:Literal>vAG</ogc:Literal>
											</ogc:PropertyIsEqualTo>
										</ogc:Or>
										<ogc:PropertyIsEqualTo>
											<ogc:PropertyName>Código</ogc:PropertyName>
											<ogc:Literal>vAF</ogc:Literal>
										</ogc:PropertyIsEqualTo>
									</ogc:Or>
									<ogc:PropertyIsEqualTo>
										<ogc:PropertyName>Código</ogc:PropertyName>
										<ogc:Literal>vAM</ogc:Literal>
									</ogc:PropertyIsEqualTo>
								</ogc:Or>
								<ogc:PropertyIsEqualTo>
									<ogc:PropertyName>Código</ogc:PropertyName>
									<ogc:Literal>vSO</ogc:Literal>
								</ogc:PropertyIsEqualTo>
							</ogc:Or>
							<ogc:PropertyIsEqualTo>
								<ogc:PropertyName>Código</ogc:PropertyName>
								<ogc:Literal>vXX</ogc:Literal>
							</ogc:PropertyIsEqualTo>
						</ogc:Or>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#FF9600</sld:CssParameter>
							<sld:CssParameter name="stroke-width">2.0</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">3.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>poligono</sld:Name>
					<sld:Title/>
					<sld:Abstract/>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
					</sld:PolygonSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
		</sld:UserStyle>
	</sld:NamedLayer>
</sld:StyledLayerDescriptor>
